unit ViewPixDevolution;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, BodyPixClass, System.UITypes;

type
  TViewPixDevolution = class(TForm)
    GroupBox3: TGroupBox;
    txtE2eid: TEdit;
    txtId: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    btnConfirmRequest: TButton;
    btnCancelRequest: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    txtValue: TEdit;
    procedure btnConfirmRequestClick(Sender: TObject);
    procedure btnCancelRequestClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    function GetE2eid: String;
    function GetId: String;
    function GetBody : String;
  public
    property e2eid: String read GetE2eid;
    property id:    String read GetId;
    property body:  String read GetBody;
    procedure ClearRequestfields;
  end;

implementation

{$R *.dfm}

procedure TViewPixDevolution.btnCancelRequestClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TViewPixDevolution.btnConfirmRequestClick(Sender: TObject);
begin

  if txtE2eid.Text = EmptyStr then
  begin
    MessageDlg('O campo EndToEndId no pode ser vazio', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtE2eid.CanFocus then
      txtE2eid.SetFocus;
  end
  else if txtId.Text = EmptyStr then
  begin
    MessageDlg('O campo Id no pode ser vazio', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtId.CanFocus then
      txtId.SetFocus;
  end
  else if txtValue.Text = EmptyStr then
  begin
    MessageDlg('Necessrio informar um valor', TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
    if txtValue.CanFocus then
      txtValue.SetFocus;
  end
  else
    ModalResult := mrOk;
end;

procedure TViewPixDevolution.FormCreate(Sender: TObject);
begin
  Self.Position := poScreenCenter;
end;

function TViewPixDevolution.GetId: String;
begin
  Result := txtId.Text;
end;

function TViewPixDevolution.GetBody: String;
var
  BodyRequest : TBodyPixDevolution;
begin
  BodyRequest := TBodyPixDevolution.Create;

  BodyRequest.Value := txtValue.Text;

  Result := BodyRequest.AsJSON;
end;

function TViewPixDevolution.GetE2eid: String;
begin
  Result := txtE2eid.Text;
end;

procedure TViewPixDevolution.ClearRequestfields;
begin
  txtE2eid.Text := '';
  txtId.Text := '';
  txtValue.Text := '';
end;

end.
